/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.ddmlib.RawImage;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class HostUtils {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);

    public static boolean isFileExist(String name) {
        return new File(name).exists();
    }

    public static BufferedImage convertRawImageToBufferedImage(RawImage rawImage) {
        assert (rawImage.bpp == 16);
        BufferedImage im = new BufferedImage(rawImage.width, rawImage.height, 8);
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(1, rawImage.width, rawImage.height, new int[]{63488, 2016, 31});
        short[] shortData = new short[rawImage.size / 2];
        for (int x = 0; x < shortData.length; ++x) {
            int rawImageOffset = x * 2;
            int a = 0xFF & rawImage.data[rawImageOffset];
            int b = 0xFF & rawImage.data[rawImageOffset + 1];
            shortData[x] = (short)(b << 8 | a);
        }
        DataBufferUShort db = new DataBufferUShort(shortData, shortData.length);
        Raster raster = Raster.createRaster(sampleModel, db, null);
        im.setData(raster);
        return im;
    }

    public static void visitAllFilesUnder(File root, FilenameFilter filter, FileVisitor visitor) {
        File[] files = root.listFiles(filter);
        if (files != null) {
            for (File f : files) {
                visitor.visitFile(f);
                if (!f.isDirectory()) continue;
                HostUtils.visitAllFilesUnder(f, filter, visitor);
            }
        }
    }

    public static void visitAllFilesUnder(String path, FilenameFilter filter, FileVisitor visitor) {
        HostUtils.visitAllFilesUnder(new File(path), filter, visitor);
    }

    public static void zipUpDirectory(String sourceDir, String outputFilePath, ZipFilenameTransformer transformer) throws IOException, ZipFileException {
        FileOutputStream fileOut = new FileOutputStream(outputFilePath);
        BufferedOutputStream bufOut = new BufferedOutputStream(fileOut);
        ZipOutputStream zipOutputStream = new ZipOutputStream(bufOut);
        ZipFileVisitor zfv = new ZipFileVisitor(zipOutputStream, transformer);
        HostUtils.visitAllFilesUnder(sourceDir, null, (FileVisitor)zfv);
        zipOutputStream.close();
        if (!zfv.isOk()) {
            throw new ZipFileException(zfv.getCaughtException());
        }
    }

    public static String getFormattedTimeString(long milliSec, String separator, String dateSeparator, String timeSeparator) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(milliSec);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int date = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        Formatter fmt = new Formatter();
        if (separator == null || separator.length() == 0) {
            separator = "_";
        }
        if (dateSeparator == null || dateSeparator.length() == 0) {
            dateSeparator = ".";
        }
        if (timeSeparator == null || timeSeparator.length() == 0) {
            timeSeparator = ".";
        }
        String formatStr = "%4d" + dateSeparator + "%02d" + dateSeparator + "%02d" + separator + "%02d" + timeSeparator + "%02d" + timeSeparator + "%02d";
        fmt.format(formatStr, year, month, date, hour, min, sec);
        return fmt.toString();
    }

    public static String toHexString(byte[] arr) {
        StringBuffer buf = new StringBuffer(arr.length * 2);
        for (byte b : arr) {
            buf.append(String.format("%02x", b & 0xFF));
        }
        return buf.toString();
    }

    public static String replaceControlChars(String s) {
        return s.replaceAll("[\\x00-\\x1f&&[^\t\n\r]]", "?");
    }

    public static Date dateFromString(String s) throws ParseException {
        return dateFormat.parse(s);
    }

    public static String dateToString(Date d) {
        return dateFormat.format(d);
    }

    public static interface ZipFilenameTransformer {
        public String transform(String var1);
    }

    static class ZipFileException
    extends Exception {
        ZipFileException(IOException ioException) {
            super("Caught wrapped exception", ioException);
        }
    }

    private static class ZipFileVisitor
    implements FileVisitor {
        private final ZipOutputStream zipOutputStream;
        private boolean ok = true;
        private IOException caughtException;
        private final ZipFilenameTransformer transformer;

        public ZipFileVisitor(ZipOutputStream zipOutputStream, ZipFilenameTransformer transformer) {
            this.zipOutputStream = zipOutputStream;
            this.transformer = transformer;
        }

        public void visitFile(File f) {
            String path = f.getPath();
            if (this.transformer != null) {
                path = this.transformer.transform(path);
            }
            ZipEntry ze = new ZipEntry(path);
            try {
                this.zipOutputStream.putNextEntry(ze);
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
                byte[] buffer = new byte[4096];
                int bytesRead = ((InputStream)is).read(buffer);
                while (bytesRead > 0) {
                    this.zipOutputStream.write(buffer, 0, bytesRead);
                    bytesRead = ((InputStream)is).read(buffer);
                }
                this.zipOutputStream.closeEntry();
            }
            catch (IOException e) {
                this.ok = false;
                this.caughtException = e;
            }
        }

        boolean isOk() {
            return this.ok;
        }

        IOException getCaughtException() {
            return this.caughtException;
        }
    }

    public static interface FileVisitor {
        public void visitFile(File var1);
    }
}

