/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.CUIOutputStream;
import com.android.cts.HostConfig;
import com.android.cts.HostUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;

public class Log {
    private static final String INFO_PREFIX = "\nCTS_INFO >>> ";
    private static final String ERROR_PREFIX = "\nCTS_ERROR >>> ";
    private static final String DEBUG_PREFIX = "\nCTS_DEBUG >>> ";
    private static final String LOG_FNAME_PREFIX = "log_";
    private static final String LOG_FNAME_SURFIX = "_.txt";
    private static PrintStream mOut = System.err;
    private static boolean TRACE = true;
    private static BufferedWriter mTraceOutput = null;
    private static boolean LOG = true;
    private static BufferedWriter mLogOutput = null;
    private static String mLogFileName;

    public static void println(String msg) {
        Log.log(INFO_PREFIX + msg);
        mOut.println(msg);
    }

    public static void i(String msg) {
        Log.log(INFO_PREFIX + msg);
        mOut.println(INFO_PREFIX + msg);
    }

    public static void e(String msg, Exception e) {
        Log.log(ERROR_PREFIX + msg);
        if (!HostConfig.DEBUG) {
            CUIOutputStream.println(ERROR_PREFIX + msg);
            if (e != null) {
                CUIOutputStream.println(e.getMessage());
            }
            return;
        }
        mOut.println(ERROR_PREFIX + msg);
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void d(String msg) {
        Log.log(DEBUG_PREFIX + System.currentTimeMillis() + " " + msg);
        if (HostConfig.DEBUG) {
            mOut.println(DEBUG_PREFIX + msg);
        }
    }

    public static void setOutput(PrintStream out) {
        if (out != null) {
            mOut = out;
        }
    }

    public static void resetOutput() {
        mOut = System.out;
    }

    public static void initLog(String path) {
        mLogFileName = path + File.separator + LOG_FNAME_PREFIX + HostUtils.getFormattedTimeString(System.currentTimeMillis(), "_", ".", ".") + LOG_FNAME_SURFIX;
        try {
            if (mLogOutput == null) {
                mLogOutput = new BufferedWriter(new FileWriter(mLogFileName));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void closeLog() {
        if (mLogOutput != null) {
            try {
                mLogOutput.close();
                mLogOutput = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void log(String msg) {
        if (LOG && mLogOutput != null) {
            try {
                if (msg != null) {
                    mLogOutput.write(msg + "\n");
                    mLogOutput.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void t(String msg) {
        if (TRACE) {
            try {
                if (mTraceOutput == null) {
                    mTraceOutput = new BufferedWriter(new FileWriter("debug.txt"));
                }
                if (msg != null) {
                    mTraceOutput.write(msg + "\n");
                    mTraceOutput.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeTrace() {
        if (mTraceOutput != null) {
            try {
                mTraceOutput.close();
                mTraceOutput = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

