/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLResourceHandler {
    protected String getElementContent(Node elem) {
        return elem.getChildNodes().item(0).getNodeValue().trim();
    }

    public static String getStringAttributeValue(Node elem, String attrName) {
        Node node = elem.getAttributes().getNamedItem(attrName);
        if (node == null) {
            return null;
        }
        return node.getNodeValue().trim();
    }

    protected int getAttributeValue(Node elem, String attrName) {
        return Integer.parseInt(XMLResourceHandler.getStringAttributeValue(elem, attrName));
    }

    protected Node getChildByAttribute(Node parent, String attrName, String attrValue) {
        if (parent == null || attrName == null || attrValue == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !attrValue.equals(XMLResourceHandler.getStringAttributeValue(child, attrName))) continue;
            return child;
        }
        return null;
    }

    protected void setAttribute(Document doc, Node elem, String name, int value) {
        this.setAttribute(doc, elem, name, Integer.toString(value));
    }

    protected void setAttribute(Document doc, Node elem, String name, String value) {
        Attr attrNode = doc.createAttribute(name);
        attrNode.setNodeValue(value);
        elem.getAttributes().setNamedItem(attrNode);
    }

    protected static void writeToFile(File file, Document doc) throws FileNotFoundException, TransformerFactoryConfigurationError, TransformerException {
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(file)));
    }
}

