/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.CtsTestResult;
import com.android.cts.HostConfig;
import com.android.cts.HostUtils;
import com.android.cts.Test;
import com.android.cts.TestNotFoundException;
import com.android.cts.TestPackage;
import com.android.cts.TestPlanNotFoundException;
import com.android.cts.TestSession;
import com.android.cts.TestSessionBuilder;
import com.android.cts.TestSessionLog;
import com.android.cts.XMLResourceHandler;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestSessionLogBuilder
extends XMLResourceHandler {
    private static TestSessionLogBuilder sInstance;
    private DocumentBuilder mDocBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

    public static TestSessionLogBuilder getInstance() throws ParserConfigurationException {
        if (sInstance == null) {
            sInstance = new TestSessionLogBuilder();
        }
        return sInstance;
    }

    private TestSessionLogBuilder() throws ParserConfigurationException {
    }

    public TestSessionLog build(String resultFilePath) throws SAXException, IOException, TestPlanNotFoundException, TestNotFoundException, NoSuchAlgorithmException, ParserConfigurationException {
        File file = new File(resultFilePath);
        if (!file.exists()) {
            throw new TestPlanNotFoundException();
        }
        Document doc = this.mDocBuilder.parse(file);
        return this.loadSessionLog(doc);
    }

    private TestSessionLog loadSessionLog(Document doc) throws NoSuchAlgorithmException, ParserConfigurationException, SAXException, IOException, TestPlanNotFoundException, TestNotFoundException {
        ArrayList<TestPackage> pkgsFromResult = new ArrayList<TestPackage>();
        NodeList resultList = doc.getElementsByTagName("TestResult");
        Node resultNode = resultList.item(0);
        String planName = TestSessionLogBuilder.getStringAttributeValue(resultNode, "testPlan");
        String start = TestSessionLogBuilder.getStringAttributeValue(resultNode, "starttime");
        String end = TestSessionLogBuilder.getStringAttributeValue(resultNode, "endtime");
        String planFilePath = HostConfig.getInstance().getPlanRepository().getPlanPath(planName);
        TestSession sessionFromPlan = TestSessionBuilder.getInstance().build(planFilePath);
        NodeList pkgList = resultNode.getChildNodes();
        for (int i = 0; i < pkgList.getLength(); ++i) {
            TestPackage pkg;
            Node pkgNode = pkgList.item(i);
            if (pkgNode.getNodeType() != 1 || !"TestPackage".equals(pkgNode.getNodeName()) || (pkg = TestSessionBuilder.getInstance().loadPackage(pkgNode, null)) == null) continue;
            pkgsFromResult.add(pkg);
        }
        Collection<TestPackage> pkgsFromPlan = sessionFromPlan.getSessionLog().getTestPackages();
        block4: for (TestPackage pkgFromPlan : pkgsFromPlan) {
            for (TestPackage pkgFromResult : pkgsFromResult) {
                if (!pkgFromPlan.getAppPackageName().equals(pkgFromResult.getAppPackageName())) continue;
                Collection<Test> testsFromPlan = pkgFromPlan.getTests();
                Collection<Test> testsFromResult = pkgFromResult.getTests();
                block6: for (Test testFromPlan : testsFromPlan) {
                    for (Test testFromResult : testsFromResult) {
                        if (!testFromPlan.getFullName().equals(testFromResult.getFullName())) continue;
                        CtsTestResult result = testFromResult.getResult();
                        testFromPlan.addResult(testFromResult.getResult());
                        continue block6;
                    }
                }
                continue block4;
            }
        }
        TestSessionLog log = new TestSessionLog(pkgsFromPlan, planName);
        try {
            log.setStartTime(HostUtils.dateFromString(start).getTime());
            log.setEndTime(HostUtils.dateFromString(end).getTime());
        }
        catch (NullPointerException ignored) {
        }
        catch (ParseException ignored) {
            // empty catch block
        }
        return log;
    }
}

