/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.ADBServerNeedRestartException;
import com.android.cts.DeviceDisconnectedException;
import com.android.cts.DeviceObserver;
import com.android.cts.Test;
import com.android.cts.TestCase;
import com.android.cts.TestDevice;
import com.android.cts.TestPackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuite
implements DeviceObserver {
    private TestPackage mParentPackage;
    private Collection<TestCase> mTestCases;
    private String mName;
    private String mFullName;
    private Collection<TestSuite> mSubSuites;
    private TestCase mCurrentTestCase;
    private TestSuite mCurrentSubSuite;
    private boolean mTestStop;

    public TestSuite(TestPackage pkg, String suiteName, String fullName) {
        this.mParentPackage = pkg;
        this.mName = suiteName;
        this.mFullName = fullName;
        this.mTestCases = new ArrayList<TestCase>();
        this.mSubSuites = new ArrayList<TestSuite>();
        this.mTestStop = false;
        this.mCurrentTestCase = null;
        this.mCurrentSubSuite = null;
    }

    public TestPackage getParent() {
        return this.mParentPackage;
    }

    public void addTestCase(TestCase tc) {
        this.mTestCases.add(tc);
    }

    public void addSubSuite(TestSuite suite) {
        this.mSubSuites.add(suite);
    }

    public Collection<TestCase> getTestCases() {
        return this.mTestCases;
    }

    public String getName() {
        return this.mName;
    }

    public String getFullName() {
        return this.mFullName;
    }

    public Collection<TestSuite> getSubSuites() {
        return this.mSubSuites;
    }

    public Collection<TestSuite> getAllSuites() {
        ArrayList<TestSuite> testSuites = new ArrayList<TestSuite>();
        testSuites.add(this);
        for (TestSuite suite : this.mSubSuites) {
            testSuites.addAll(suite.getAllSuites());
        }
        return testSuites;
    }

    public Test searchTest(String testName) {
        Test test = null;
        for (TestCase testCase : this.mTestCases) {
            test = testCase.searchTest(testName);
            if (test == null) continue;
            return test;
        }
        if (this.mSubSuites.size() != 0) {
            for (TestSuite subSuite : this.mSubSuites) {
                test = subSuite.searchTest(testName);
                if (test == null) continue;
                return test;
            }
        }
        return null;
    }

    public ArrayList<String> getExcludedList(String resultType) {
        ArrayList<String> list;
        ArrayList<String> excludedList = new ArrayList<String>();
        ArrayList<String> fullNameList = new ArrayList<String>();
        for (TestSuite suite : this.mSubSuites) {
            fullNameList.add(suite.getFullName());
            list = suite.getExcludedList(resultType);
            if (list == null || list.size() <= 0) continue;
            excludedList.addAll(list);
        }
        for (TestCase tc : this.mTestCases) {
            fullNameList.add(tc.getFullName());
            list = tc.getExcludedList(resultType);
            if (list == null || list.size() <= 0) continue;
            excludedList.addAll(list);
        }
        int count = 0;
        for (String fullName : fullNameList) {
            if (!excludedList.contains(fullName)) continue;
            ++count;
        }
        if (count == fullNameList.size()) {
            excludedList.removeAll(excludedList);
            excludedList.add(this.getFullName());
        }
        return excludedList;
    }

    public Collection<Test> getTests() {
        ArrayList<Test> tests = new ArrayList<Test>();
        for (TestSuite subSuite : this.mSubSuites) {
            tests.addAll(subSuite.getTests());
        }
        for (TestCase testCase : this.mTestCases) {
            tests.addAll(testCase.getTests());
        }
        return tests;
    }

    public Collection<TestCase> getAllTestCases() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        testCases.addAll(this.mTestCases);
        for (TestSuite subSuite : this.mSubSuites) {
            testCases.addAll(subSuite.getAllTestCases());
        }
        return testCases;
    }

    public ArrayList<String> getAllTestCaseNames() {
        ArrayList<String> caseNameList = new ArrayList<String>();
        for (TestCase testCase : this.getAllTestCases()) {
            caseNameList.add(testCase.getFullName());
        }
        return caseNameList;
    }

    public void setTestStopped(boolean testStopped) {
        this.mTestStop = testStopped;
        if (this.mCurrentTestCase != null) {
            this.mCurrentTestCase.setTestStopped(this.mTestStop);
        }
        if (this.mCurrentSubSuite != null) {
            this.mCurrentSubSuite.setTestStopped(this.mTestStop);
        }
    }

    public void run(TestDevice device, String javaPkgName) throws IOException, DeviceDisconnectedException, ADBServerNeedRestartException {
        Iterator<TestSuite> subSuites = this.getSubSuites().iterator();
        Iterator<TestCase> testCases = this.getTestCases().iterator();
        this.mTestStop = false;
        this.mCurrentTestCase = null;
        this.mCurrentSubSuite = null;
        while (subSuites.hasNext() && !this.mTestStop) {
            this.mCurrentSubSuite = subSuites.next();
            this.mCurrentSubSuite.run(device, javaPkgName);
        }
        while (testCases.hasNext() && !this.mTestStop) {
            this.mCurrentTestCase = testCases.next();
            String fullName = this.mFullName + "." + this.mCurrentTestCase.getName();
            if (javaPkgName != null && javaPkgName.length() != 0 && !fullName.startsWith(javaPkgName)) continue;
            this.mCurrentTestCase.run(device);
        }
    }

    public void run(TestDevice device, Test test) throws DeviceDisconnectedException, ADBServerNeedRestartException {
        this.mTestStop = false;
        this.mCurrentTestCase = null;
        this.mCurrentSubSuite = null;
        this.mCurrentTestCase = test.getTestCase();
        this.mCurrentTestCase.run(device, test);
    }

    @Override
    public void notifyInstallingComplete(int resultCode) {
        if (this.mCurrentTestCase != null) {
            this.mCurrentTestCase.notifyInstallingComplete(resultCode);
        }
        if (this.mCurrentSubSuite != null) {
            this.mCurrentSubSuite.notifyInstallingComplete(resultCode);
        }
    }

    @Override
    public void notifyUninstallingComplete(int resultCode) {
        if (this.mCurrentTestCase != null) {
            this.mCurrentTestCase.notifyUninstallingComplete(resultCode);
        }
        if (this.mCurrentSubSuite != null) {
            this.mCurrentSubSuite.notifyUninstallingComplete(resultCode);
        }
    }

    @Override
    public void notifyInstallingTimeout(TestDevice testDevice) {
        if (this.mCurrentTestCase != null) {
            this.mCurrentTestCase.notifyInstallingTimeout(testDevice);
        }
        if (this.mCurrentSubSuite != null) {
            this.mCurrentSubSuite.notifyInstallingTimeout(testDevice);
        }
    }

    @Override
    public void notifyUninstallingTimeout(TestDevice testDevice) {
        if (this.mCurrentTestCase != null) {
            this.mCurrentTestCase.notifyUninstallingTimeout(testDevice);
        }
        if (this.mCurrentSubSuite != null) {
            this.mCurrentSubSuite.notifyUninstallingTimeout(testDevice);
        }
    }

    @Override
    public void notifyTestingDeviceDisconnected() {
        if (this.mCurrentTestCase != null) {
            this.mCurrentTestCase.notifyTestingDeviceDisconnected();
        }
        if (this.mCurrentSubSuite != null) {
            this.mCurrentSubSuite.notifyTestingDeviceDisconnected();
        }
    }
}

