/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.HostTimer;
import com.android.cts.HostUnitTestRunner;
import com.android.cts.Log;
import com.android.cts.Test;
import com.android.cts.TestCase;
import com.android.cts.TestController;
import java.io.IOException;
import junit.framework.TestResult;

public class HostSideOnlyTest
extends Test {
    private HostSideTestRunner mHostSideTestRunner = null;

    public HostSideOnlyTest(TestCase parentCase, String name, String type, String knownFailure, int resCode) {
        super(parentCase, name, type, knownFailure, resCode);
    }

    protected void runImpl() {
        this.mHostSideTestRunner = new HostSideTestRunner(this);
        this.mHostSideTestRunner.start();
    }

    class HostSideTestRunner
    extends Thread {
        private HostSideOnlyTest mTest;

        public HostSideTestRunner(HostSideOnlyTest test) {
            this.mTest = test;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HostUnitTestRunner runner = new HostUnitTestRunner(this.mTest);
            TestController controller = this.mTest.getTestController();
            TestResult testResult = null;
            try {
                testResult = runner.runTest(controller.getJarPath(), controller.getPackageName(), controller.getClassName(), controller.getMethodName());
            }
            catch (IOException e) {
                Log.e("IOException while running test from " + controller.getJarPath(), e);
            }
            catch (ClassNotFoundException e) {
                Log.e("The host controller JAR (" + controller.getJarPath() + ") file doesn't contain class: " + controller.getPackageName() + "." + controller.getClassName(), e);
            }
            HostTimer hostTimer = HostSideOnlyTest.this.mTimeOutTimer;
            synchronized (hostTimer) {
                HostSideOnlyTest.this.mResult.setResult(testResult);
                if (!HostSideOnlyTest.this.mTimeOutTimer.isTimeOut()) {
                    Log.d("HostSideTestRunnerThread() detects that it needs to cancel mTimeOutTimer");
                    HostSideOnlyTest.this.mTimeOutTimer.sendNotify();
                }
            }
        }
    }
}

