/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.HostConfig;
import com.android.cts.HostSideOnlyTest;
import com.android.cts.Log;
import com.android.hosttest.DeviceTest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;

public class HostUnitTestRunner
extends BaseTestRunner {
    private static String JAR_SUFFIX = ".jar";
    private TestCase mTestCase = null;
    private HostSideOnlyTest mTest;

    public HostUnitTestRunner(HostSideOnlyTest test) {
        this.mTest = test;
    }

    public TestResult runTest(String jarPath, String testPkgName, String testClassName, String testMethodName) throws ClassNotFoundException, IOException {
        TestResult result = new TestResult();
        this.loadTestCase(jarPath, testPkgName, testClassName, testMethodName);
        if (this.mTestCase != null) {
            if (this.mTestCase instanceof DeviceTest) {
                DeviceTest deviceTest = (DeviceTest)this.mTestCase;
                deviceTest.setDevice(this.mTest.mDevice.getDevice());
                deviceTest.setTestAppPath(HostConfig.getInstance().getCaseRepository().getRoot());
            }
            this.mTestCase.run(result);
        }
        return result;
    }

    public TestCase loadTestCase(String jarPath, String testPkgName, String testClassName, String testMethodName) throws ClassNotFoundException, IOException {
        Log.d("jarPath=" + jarPath + ",testPkgName=" + testPkgName + ",testClassName=" + testClassName);
        Class<?> testClass = null;
        testClass = jarPath != null && jarPath.endsWith(JAR_SUFFIX) ? this.loadClass(jarPath, testPkgName, testClassName) : Class.forName(testPkgName + "." + testClassName);
        if (testMethodName != null && TestCase.class.isAssignableFrom(testClass)) {
            this.mTestCase = this.buildTestMethod(testClass, testMethodName);
        }
        return this.mTestCase;
    }

    public Class loadClass(String jarPath, String testPkgName, String testClassName) throws ClassNotFoundException, IOException {
        URL[] urls = new URL[]{new File(jarPath).getCanonicalFile().toURI().toURL()};
        URLClassLoader cl = new URLClassLoader(urls);
        Class<?> testClass = cl.loadClass(testPkgName + "." + testClassName);
        Log.d("succeed in load jarred class: " + jarPath + "." + testPkgName + "." + testClassName);
        return testClass;
    }

    private TestCase buildTestMethod(Class testClass, String testMethodName) {
        try {
            TestCase testCase = (TestCase)testClass.newInstance();
            testCase.setName(testMethodName);
            return testCase;
        }
        catch (IllegalAccessException e) {
            this.runFailed("Could not access test class. Class: " + testClass.getName());
        }
        catch (InstantiationException e) {
            this.runFailed("Could not instantiate test class. Class: " + testClass.getName());
        }
        return null;
    }

    public void testStarted(String testName) {
    }

    public void testEnded(String testName) {
    }

    public void testFailed(int status, Test test, Throwable t) {
    }

    protected void runFailed(String message) {
        throw new RuntimeException(message);
    }
}

