/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.ADBServerNeedRestartException;
import com.android.cts.CUIOutputStream;
import com.android.cts.CtsTestResult;
import com.android.cts.DeviceDisconnectedException;
import com.android.cts.DeviceObserver;
import com.android.cts.HostConfig;
import com.android.cts.HostTimer;
import com.android.cts.HostUtils;
import com.android.cts.InvalidApkPathException;
import com.android.cts.InvalidNameSpaceException;
import com.android.cts.Log;
import com.android.cts.ProgressObserver;
import com.android.cts.Test;
import com.android.cts.TestCase;
import com.android.cts.TestDevice;
import com.android.cts.TestSession;
import com.android.cts.TestSessionLog;
import com.android.cts.TestSuite;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPackage
implements DeviceObserver {
    protected static final String PKG_LOG_SEPARATOR = "==============================================================";
    public static final String FINISH = "finish";
    public static final String START = "start";
    private String mName;
    private String mVersion;
    private String mAndroidVersion;
    private String mTargetNameSpace;
    private String mTargetBinaryName;
    private String mInstrumentationRunner;
    private Collection<TestSuite> mSuites;
    private String mDigest;
    private String mJarPath;
    private String mAppNameSpace;
    private String mAppPackageName;
    protected TestSuite mCurrentTestSuite;
    protected TestDevice mDevice;
    protected boolean mTestStop;
    private TestSession.TestSessionThread mTestThread;
    private HostTimer mTimeOutTimer;
    private ProgressObserver mProgressObserver;
    private boolean mIsInBatchMode;
    private Test mCurrentTest;

    public TestPackage(String instrumentationRunner, String testPkgBinaryName, String targetNameSpace, String targetBinaryName, String version, String androidVersion, String jarPath, String appNameSpace, String appPackageName) {
        this.mInstrumentationRunner = instrumentationRunner;
        this.mName = testPkgBinaryName;
        this.mTargetNameSpace = targetNameSpace;
        this.mTargetBinaryName = targetBinaryName;
        this.mVersion = version;
        this.mAndroidVersion = androidVersion;
        this.mSuites = new ArrayList<TestSuite>();
        this.mJarPath = jarPath;
        this.mAppNameSpace = appNameSpace;
        this.mAppPackageName = appPackageName;
        this.mDevice = null;
        this.mTestStop = false;
        this.mTestThread = null;
        this.mIsInBatchMode = false;
        this.mCurrentTest = null;
    }

    public String getAppNameSpace() {
        return this.mAppNameSpace;
    }

    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    public boolean isHostSideOnly() {
        return false;
    }

    public void addTestSuite(TestSuite suite) {
        this.mSuites.add(suite);
    }

    public Collection<TestSuite> getTestSuites() {
        return this.mSuites;
    }

    public TestSuite getTestSuiteByName(String suiteFullName) {
        for (TestSuite suite : this.getAllTestSuites()) {
            if (!suite.getFullName().equals(suiteFullName)) continue;
            return suite;
        }
        return null;
    }

    public TestCase getTestCaseByName(String testCaseFullName) {
        for (TestCase testCase : this.getAllTestCases()) {
            if (!testCase.getFullName().equals(testCaseFullName)) continue;
            return testCase;
        }
        return null;
    }

    public Collection<TestSuite> getAllTestSuites() {
        ArrayList<TestSuite> suites = new ArrayList<TestSuite>();
        for (TestSuite suite : this.mSuites) {
            suites.addAll(suite.getAllSuites());
        }
        return suites;
    }

    public void getTestSuiteNames(String expectName, List<String> suiteNameList, List<String> caseNameList) {
        for (TestCase testCase : this.getAllTestCases()) {
            String testCaseName = testCase.getFullName();
            if (!testCaseName.startsWith(expectName)) continue;
            String suiteName = testCaseName.substring(0, testCaseName.lastIndexOf("."));
            if (suiteName.equals(expectName)) {
                if (caseNameList.contains(testCaseName)) continue;
                caseNameList.add(testCaseName);
                continue;
            }
            if (suiteNameList.contains(suiteName)) continue;
            suiteNameList.add(suiteName);
        }
    }

    public List<String> getAllTestSuiteNames() {
        ArrayList<String> suiteNameList = new ArrayList<String>();
        for (TestCase testCase : this.getAllTestCases()) {
            String testCaseName = testCase.getFullName();
            String suiteName = testCaseName.substring(0, testCaseName.lastIndexOf("."));
            if (suiteNameList.contains(suiteName)) continue;
            suiteNameList.add(suiteName);
        }
        return suiteNameList;
    }

    public List<String> getAllTestCaseNames(String suiteFullName) {
        ArrayList<String> caseNameList = new ArrayList<String>();
        TestSuite suite = this.getTestSuiteByName(suiteFullName);
        if (suite != null) {
            caseNameList.addAll(suite.getAllTestCaseNames());
        }
        return caseNameList;
    }

    public List<String> getAllTestNames(String testCaseFullName) {
        ArrayList<String> testNameList = new ArrayList<String>();
        TestCase testCase = this.getTestCaseByName(testCaseFullName);
        if (testCase != null) {
            testNameList.addAll(testCase.getAllTestNames());
        }
        return testNameList;
    }

    public void getTestCaseNames(String expectPackage, List<String> caseList, List<String> testList) {
        for (TestCase testCase : this.getAllTestCases()) {
            String testCaseName = testCase.getFullName();
            if (testCaseName.equals(expectPackage)) {
                for (Test test : testCase.getTests()) {
                    testList.add(test.getFullName());
                }
                return;
            }
            if (!testCaseName.startsWith(expectPackage)) continue;
            caseList.add(testCaseName);
        }
    }

    public void getTestNames(String expectPackage, List<String> testList) {
        for (Test test : this.getTests()) {
            String testName = test.getFullName();
            if (!testName.startsWith(expectPackage)) continue;
            testList.add(testName);
        }
    }

    public String getAppBinaryName() {
        return this.mName;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getAndroidVersion() {
        return this.mAndroidVersion;
    }

    public String getTargetNameSpace() {
        return this.mTargetNameSpace;
    }

    public String getTargetBinaryName() {
        return this.mTargetBinaryName;
    }

    public String getInstrumentationRunner() {
        return this.mInstrumentationRunner;
    }

    public Test searchTest(String testName) {
        TestSuite suite;
        Test test = null;
        Iterator<TestSuite> i$ = this.mSuites.iterator();
        while (i$.hasNext() && (test = (suite = i$.next()).searchTest(testName)) == null) {
        }
        return test;
    }

    public Collection<Test> getTests() {
        ArrayList<Test> tests = new ArrayList<Test>();
        for (TestSuite s : this.mSuites) {
            tests.addAll(s.getTests());
        }
        return tests;
    }

    public Collection<TestCase> getAllTestCases() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        for (TestSuite s : this.mSuites) {
            testCases.addAll(s.getAllTestCases());
        }
        return testCases;
    }

    private void setMessageDigest(String digest) {
        this.mDigest = digest;
    }

    public String getMessageDigest() {
        return this.mDigest;
    }

    public String getJarPath() {
        return this.mJarPath;
    }

    public ArrayList<String> getExcludedList(String resultType) {
        ArrayList<String> excludedList = new ArrayList<String>();
        ArrayList<String> fullNameList = new ArrayList<String>();
        for (TestSuite suite : this.getTestSuites()) {
            fullNameList.add(suite.getFullName());
            ArrayList<String> list = suite.getExcludedList(resultType);
            if (list == null || list.size() <= 0) continue;
            excludedList.addAll(list);
        }
        int count = 0;
        for (String fullName : fullNameList) {
            if (!excludedList.contains(fullName)) continue;
            ++count;
        }
        if (count == fullNameList.size()) {
            return null;
        }
        return excludedList;
    }

    protected void println(String msg) {
        if (!this.mTestStop) {
            CUIOutputStream.println(msg);
        }
    }

    protected void print(String msg) {
        if (!this.mTestStop) {
            CUIOutputStream.print(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBatchModeFinish() {
        Log.d("TestPackage.notifyBatchModeFinish() is called, mTestStop=" + this.mTestStop);
        if (this.mTestStop) {
            return;
        }
        if (this.mIsInBatchMode) {
            if (this.mCurrentTest != null) {
                this.handleMissingFinishEvent();
            }
            HostTimer hostTimer = this.mTimeOutTimer;
            synchronized (hostTimer) {
                this.mTimeOutTimer.sendNotify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMissingFinishEvent() {
        this.mProgressObserver.stop();
        HostTimer hostTimer = this.mTimeOutTimer;
        synchronized (hostTimer) {
            this.mTimeOutTimer.cancel(false);
        }
        this.mCurrentTest.setResult(new CtsTestResult(0, null, null));
        this.mCurrentTest = null;
    }

    public void notifyTestStatus(Test test, String status) {
        if (this.mTestStop) {
            return;
        }
        if (this.mIsInBatchMode) {
            if (status.equals(START)) {
                if (this.mCurrentTest != null && this.mCurrentTest.getResult().isNotExecuted()) {
                    Log.d("Err: Missing FINISH msg for test " + this.mCurrentTest.getFullName());
                    this.handleMissingFinishEvent();
                }
                this.mCurrentTest = test;
                if (test != null) {
                    this.print(this.mCurrentTest.getFullName() + "...");
                    this.mProgressObserver.start();
                }
            } else {
                this.mProgressObserver.stop();
                this.mCurrentTest = null;
            }
            this.mTimeOutTimer.restart(new TimeOutTask(this), HostConfig.Ints.testStatusTimeoutMs.value());
        }
    }

    @Override
    public void notifyInstallingComplete(int resultCode) {
        Log.d("notifyInstallingComplete() is called with resultCode=" + resultCode);
        this.sendNotify();
        if (resultCode == -1) {
            Log.d("install failed");
        }
    }

    @Override
    public void notifyUninstallingComplete(int resultCode) {
        Log.d("notifyUninstallingComplete() is called with resultCode=" + resultCode);
        this.sendNotify();
        if (resultCode == -1) {
            Log.d("uninstall failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotify() {
        TestPackage testPackage = this;
        synchronized (testPackage) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyInstallingTimeout(TestDevice testDevice) {
        Log.d("TestPackage.notifyInstallingTimeout() is called");
        this.mTestStop = true;
        TestPackage testPackage = this;
        synchronized (testPackage) {
            this.notify();
        }
        this.genPackageActionTimeoutCause(testDevice, "Installing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyUninstallingTimeout(TestDevice testDevice) {
        Log.d("TestPackage.notifyUninstallingTimeout() is called");
        this.mTestStop = true;
        TestPackage testPackage = this;
        synchronized (testPackage) {
            this.notify();
        }
        this.genPackageActionTimeoutCause(testDevice, "Uninstalling");
    }

    private void genPackageActionTimeoutCause(TestDevice testDevice, String type) {
        String cause = testDevice.getStatus() == 2 ? testDevice.getSerialNumber() + " is offline." : "Unknown reason.";
        if (type == null) {
            type = "Unknown timer";
        }
        Log.e(type + " met timeout due to " + cause, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTestingDeviceDisconnected() {
        Log.d("busyDeviceDisconnected invoked");
        this.mTestStop = true;
        TestPackage testPackage = this;
        synchronized (testPackage) {
            this.notify();
        }
        this.cleanUp();
        try {
            CUIOutputStream.println("Test stopped.");
            this.mTestThread.join();
        }
        catch (InterruptedException e) {
            Log.d("test thread interrupted");
        }
    }

    public void setTestDevice(TestDevice device) {
        this.mDevice = device;
        device.setRuntimeListener(this);
        device.setStatus(1);
    }

    private String getFullPath(String binaryFileName) {
        String packagePath = null;
        if (binaryFileName != null && binaryFileName.length() != 0) {
            packagePath = HostConfig.getInstance().getCaseRepository().getApkPath(binaryFileName);
        }
        return packagePath;
    }

    private boolean install() throws DeviceDisconnectedException, InvalidApkPathException {
        String packageBinaryName = this.getAppBinaryName();
        String targetBinaryName = this.getTargetBinaryName();
        String packagePath = this.getFullPath(packageBinaryName);
        String targetApkPath = this.getFullPath(targetBinaryName);
        boolean success = true;
        if (packagePath != null) {
            this.installAPK(packagePath);
            if (!this.mTestStop && targetApkPath != null) {
                this.installAPK(targetApkPath);
            }
        } else {
            success = false;
            Log.e("The package binary name contains nothing!", null);
        }
        if (this.mTestStop) {
            success = false;
            this.println("Install package " + packageBinaryName + "failed");
        }
        return success;
    }

    private void uninstall() throws DeviceDisconnectedException, InvalidNameSpaceException {
        String testPkgBinaryName = this.getAppBinaryName();
        String appNameSpace = this.getAppNameSpace();
        String targetNameSpace = this.getTargetNameSpace();
        String packagePath = this.getFullPath(testPkgBinaryName);
        String targetApkPath = this.getFullPath(targetNameSpace);
        if (packagePath != null && HostUtils.isFileExist(packagePath)) {
            this.uninstallAPK(appNameSpace);
            if (!this.mTestStop && targetNameSpace != null && targetApkPath != null && HostUtils.isFileExist(targetApkPath)) {
                this.uninstallAPK(targetNameSpace);
            }
        }
    }

    private void uninstallAPK(String packageName) throws DeviceDisconnectedException, InvalidNameSpaceException {
        Log.d("Uninstall: " + packageName);
        this.mDevice.uninstallAPK(packageName);
        this.waitPackageActionComplete();
    }

    private void installAPK(String apkPath) throws DeviceDisconnectedException, InvalidApkPathException {
        Log.d("installAPK " + apkPath + " ...");
        this.mDevice.installAPK(apkPath);
        this.waitPackageActionComplete();
        Log.d("installAPK " + apkPath + " finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitPackageActionComplete() {
        Log.d("Enter waitPackageActionComplete()");
        TestPackage testPackage = this;
        synchronized (testPackage) {
            if (!this.mTestStop) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.d("interrupted while waiting for package action complete");
                }
            }
        }
        try {
            Thread.sleep(HostConfig.Ints.postInstallWaitMs.value());
        }
        catch (InterruptedException e) {
            Log.d("sleeping after package action complete interrupted");
        }
        Log.d("Leave waitPackageActionComplete()");
    }

    private String genMessageDigest(String packagePath) throws IOException {
        String algorithm = "SHA-1";
        FileInputStream fin = new FileInputStream(packagePath);
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[1024];
            while ((len = fin.read(buffer)) != -1) {
                md.update(buffer, 0, len);
            }
            fin.close();
            return HostUtils.toHexString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return "SHA-1 not found";
        }
    }

    public void setSessionThread(TestSession.TestSessionThread thread) {
        this.mTestThread = thread;
    }

    private boolean supportsBatchMode() {
        Collection<Test> tests = this.getTests();
        if (tests.size() > HostConfig.Ints.maxTestsInBatchMode.value()) {
            return false;
        }
        for (Test test : tests) {
            if (!test.getResult().isNotExecuted()) {
                return false;
            }
            if (test.getTestController() == null || test.getTestController().getFullName() == null) continue;
            return false;
        }
        return true;
    }

    List<String> getPackageNames() {
        ArrayList<String> pkgNames = new ArrayList<String>();
        List<String> suiteNames = this.getAllTestSuiteNames();
        Iterator<String> i$ = suiteNames.iterator();
        while (i$.hasNext()) {
            String suiteName;
            String pkgSeg = suiteName = i$.next();
            if (suiteName.contains(".")) {
                pkgSeg = suiteName.split("\\.")[0];
            }
            if (pkgNames.contains(pkgSeg)) continue;
            pkgNames.add(pkgSeg);
        }
        return pkgNames;
    }

    private void runInBatchMode(String javaPkgName) throws DeviceDisconnectedException {
        this.mTimeOutTimer = new HostTimer(new TimeOutTask(this), HostConfig.Ints.batchStartTimeoutMs.value());
        this.mTimeOutTimer.start();
        this.mProgressObserver = new ProgressObserver();
        if (javaPkgName != null && javaPkgName.length() > 0) {
            this.runInBatchModeImpl(javaPkgName);
        } else {
            for (String pkgName : this.getPackageNames()) {
                this.runInBatchModeImpl(pkgName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInBatchModeImpl(String javaPkgName) throws DeviceDisconnectedException {
        this.mDevice.runInBatchMode(this, javaPkgName);
        HostTimer hostTimer = this.mTimeOutTimer;
        synchronized (hostTimer) {
            if (!this.mTestStop) {
                try {
                    this.mTimeOutTimer.waitOn();
                }
                catch (InterruptedException e) {
                    Log.d("time out object interrupted");
                }
            }
            this.mProgressObserver.stop();
            if (this.mTimeOutTimer.isTimeOut()) {
                return;
            }
            this.mTimeOutTimer.cancel(false);
        }
    }

    protected void runInIndividualMode(String javaPkgName) throws IOException, DeviceDisconnectedException, ADBServerNeedRestartException {
        Iterator<TestSuite> suites = this.getTestSuites().iterator();
        while (suites.hasNext() && !this.mTestStop) {
            this.mCurrentTestSuite = suites.next();
            this.mCurrentTestSuite.run(this.mDevice, javaPkgName);
        }
    }

    private void killDeviceProcess(String packageName) {
        this.mDevice.killProcess(packageName);
    }

    protected boolean isAllTestsRun() {
        for (Test test : this.getTests()) {
            if (!test.getResult().isNotExecuted()) continue;
            return false;
        }
        return true;
    }

    protected boolean noTestsExecuted() {
        for (Test test : this.getTests()) {
            if (test.getResult().isNotExecuted()) continue;
            return false;
        }
        return true;
    }

    public void run(TestDevice device, String javaPkgName, TestSessionLog sessionLog) throws IOException, DeviceDisconnectedException, ADBServerNeedRestartException, InvalidApkPathException, InvalidNameSpaceException {
        if (this.isAllTestsRun()) {
            return;
        }
        this.setup(device, javaPkgName);
        this.runImpl(javaPkgName);
    }

    protected void runImpl(String javaPkgName) throws IOException, DeviceDisconnectedException, ADBServerNeedRestartException, InvalidApkPathException, InvalidNameSpaceException {
        try {
            if (!this.install()) {
                return;
            }
            if (!this.mTestStop) {
                Log.d("install " + this.getAppBinaryName() + " succeed!");
                this.setMessageDigest(this.genMessageDigest(HostConfig.getInstance().getCaseRepository().getApkPath(this.getAppBinaryName())));
                if (this.supportsBatchMode()) {
                    this.mIsInBatchMode = true;
                    Log.d("run in batch mode...");
                    this.runInBatchMode(javaPkgName);
                    if (!this.isAllTestsRun()) {
                        this.mIsInBatchMode = false;
                        Log.d("run in individual mode");
                        this.runInIndividualMode(javaPkgName);
                    }
                } else {
                    Log.d("run in individual mode...");
                    this.runInIndividualMode(javaPkgName);
                }
            }
            if (!this.mTestStop) {
                this.uninstall();
                if (!TestSession.isADBServerRestartedMode()) {
                    this.println(PKG_LOG_SEPARATOR);
                }
            }
        }
        catch (DeviceDisconnectedException e) {
            this.cleanUp();
            throw e;
        }
    }

    protected void setup(TestDevice device, String javaPkgName) {
        if (!TestSession.isADBServerRestartedMode() || this.noTestsExecuted()) {
            this.println(PKG_LOG_SEPARATOR);
            if (javaPkgName == null || javaPkgName.length() == 0) {
                this.println("Test package: " + this.getAppPackageName());
            } else {
                this.println("Test java package contained in test package " + this.getAppPackageName() + ": " + javaPkgName);
            }
        }
        this.mTestStop = false;
        this.mIsInBatchMode = false;
        this.mCurrentTest = null;
        this.mCurrentTestSuite = null;
        this.setTestDevice(device);
    }

    public void cleanUp() {
        if (this.mCurrentTestSuite != null) {
            this.mCurrentTestSuite.setTestStopped(this.mTestStop);
            this.mCurrentTestSuite.notifyTestingDeviceDisconnected();
        }
        if (this.mProgressObserver != null) {
            this.mProgressObserver.stop();
        }
        if (this.mTimeOutTimer != null) {
            this.mTimeOutTimer.cancel(false);
        }
    }

    public void runTest(TestDevice device, Test test) throws DeviceDisconnectedException, ADBServerNeedRestartException, InvalidApkPathException, InvalidNameSpaceException {
        if (test == null) {
            return;
        }
        this.mTestStop = false;
        this.mIsInBatchMode = false;
        this.println(PKG_LOG_SEPARATOR);
        this.println("Test package: " + this.getAppPackageName());
        this.setTestDevice(device);
        this.runTestImpl(test);
    }

    protected void runTestImpl(Test test) throws DeviceDisconnectedException, ADBServerNeedRestartException, InvalidApkPathException, InvalidNameSpaceException {
        try {
            if (!this.install()) {
                return;
            }
            if (!this.mTestStop) {
                Log.d("install " + this.getAppPackageName() + " succeed!");
                this.mCurrentTestSuite = test.getTestSuite();
                this.mCurrentTestSuite.run(this.mDevice, test);
            }
            if (!this.mTestStop) {
                this.uninstall();
                this.println(PKG_LOG_SEPARATOR);
            }
        }
        catch (DeviceDisconnectedException e) {
            this.cleanUp();
            throw e;
        }
    }

    class TimeOutTask
    extends TimerTask {
        private TestPackage mTestPackage;

        public TimeOutTask(TestPackage testPackage2) {
            this.mTestPackage = testPackage2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TestPackage.this.mProgressObserver.stop();
            HostTimer hostTimer = TestPackage.this.mTimeOutTimer;
            synchronized (hostTimer) {
                TestPackage.this.mTimeOutTimer.cancel(true);
                TestPackage.this.mTimeOutTimer.sendNotify();
            }
            if (TestPackage.this.mIsInBatchMode && TestPackage.this.mCurrentTest != null) {
                TestPackage.this.mCurrentTest.setResult(new CtsTestResult(4, null, null));
                TestPackage.this.mCurrentTest = null;
            }
            Log.d("mTimeOutTimer timed out");
            TestPackage.this.killDeviceProcess(this.mTestPackage.getAppPackageName());
        }
    }
}

