/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.CtsTestResult;
import com.android.cts.HostConfig;
import com.android.cts.HostUtils;
import com.android.cts.Log;
import com.android.cts.SignatureCheckPackage;
import com.android.cts.Test;
import com.android.cts.TestCase;
import com.android.cts.TestDevice;
import com.android.cts.TestPackage;
import com.android.cts.TestSuite;
import com.android.cts.Version;
import com.android.cts.XMLResourceHandler;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSessionLog
extends XMLResourceHandler {
    private static final String EXPR_TEST_FAILED = ".+\\((\\S+):(\\d+)\\)";
    private static Pattern mTestFailedPattern = Pattern.compile(".+\\((\\S+):(\\d+)\\)");
    private static final String ATTRIBUTE_NAME = "name";
    static final String ATTRIBUTE_RESULT = "result";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ATTRIBUTE_DIGEST = "digest";
    private static final String ATTRIBUTE_KNOWN_FAILURE = "KnownFailure";
    public static final String CTS_RESULT_FILE_NAME = "testResult.xml";
    private static final String CTS_RESULT_FILE_VERSION = "1.10";
    static final String ATTRIBUTE_STARTTIME = "starttime";
    static final String ATTRIBUTE_ENDTIME = "endtime";
    static final String ATTRIBUTE_TESTPLAN = "testPlan";
    static final String ATTRIBUTE_RESOLUTION = "resolution";
    static final String ATTRIBUTE_SUBSCRIBER_ID = "subscriberId";
    static final String ATTRIBUTE_DEVICE_ID = "deviceID";
    static final String ATTRIBUTE_BUILD_ID = "buildID";
    static final String ATTRIBUTE_BUILD_VERSION = "buildVersion";
    static final String ATTRIBUTE_ANDROID_PLATFORM_VERSION = "androidPlatformVersion";
    static final String ATTRIBUTE_LOCALES = "locales";
    static final String ATTRIBUTE_XDPI = "Xdpi";
    static final String ATTRIBUTE_YDPI = "Ydpi";
    static final String ATTRIBUTE_TOUCH = "touch";
    static final String ATTRIBUTE_NAVIGATION = "navigation";
    static final String ATTRIBUTE_KEYPAD = "keypad";
    static final String ATTRIBUTE_NETWORK = "network";
    static final String ATTRIBUTE_IMEI = "imei";
    static final String ATTRIBUTE_IMSI = "imsi";
    static final String ATTRIBUTE_BUILD_NAME = "buildName";
    static final String ATTRIBUTE_ARCH = "arch";
    static final String ATTRIBUTE_VALUE = "value";
    static final String ATTRIBUTE_AVAILABLE = "available";
    static final String ATTRIBUTE_TYPE = "type";
    static final String ATTRIBUTE_UID = "uid";
    static final String ATTRIBUTE_OPEN_GL_ES_VERSION = "openGlEsVersion";
    static final String ATTRIBUTE_PASS = "pass";
    static final String ATTRIBUTE_FAILED = "failed";
    static final String ATTRIBUTE_TIMEOUT = "timeout";
    static final String ATTRIBUTE_OMITTED = "omitted";
    static final String ATTRIBUTE_NOT_EXECUTED = "notExecuted";
    static final String TAG_DEVICEINFO = "DeviceInfo";
    static final String TAG_HOSTINFO = "HostInfo";
    static final String TAG_OSINFO = "Os";
    static final String TAG_JAVA = "Java";
    static final String TAG_CTS = "Cts";
    static final String TAG_INTVALUE = "IntValue";
    static final String TAG_SUMMARY = "Summary";
    static final String TAG_SCREEN = "Screen";
    static final String TAG_BUILD_INFO = "BuildInfo";
    static final String TAG_FEATURE_INFO = "FeatureInfo";
    static final String TAG_FEATURE = "Feature";
    static final String TAG_PROCESS_INFO = "ProcessInfo";
    static final String TAG_PROCESS = "Process";
    static final String TAG_PHONE_SUB_INFO = "PhoneSubInfo";
    static final String TAG_TEST_RESULT = "TestResult";
    static final String TAG_TESTPACKAGE = "TestPackage";
    static final String TAG_TESTSUITE = "TestSuite";
    static final String TAG_TESTCASE = "TestCase";
    static final String TAG_FAILED_SCENE = "FailedScene";
    static final String TAG_STACK_TRACE = "StackTrace";
    static final String TAG_FAILED_MESSAGE = "message";
    private Collection<TestPackage> mTestPackages;
    private Date mSessionStartTime;
    private Date mSessionEndTime;
    private String mResultPath;
    private String mResultDir;
    private String mTestPlanName;
    private ArrayList<TestDevice.DeviceParameterCollector> mDeviceParameterBase;

    public TestSessionLog(Collection<TestPackage> packages, String testPlanName) {
        this.mTestPackages = packages;
        this.mDeviceParameterBase = new ArrayList();
        this.mTestPlanName = testPlanName;
        this.mSessionStartTime = new Date();
        this.mSessionEndTime = new Date();
    }

    public String getTestPlanName() {
        return this.mTestPlanName;
    }

    public Collection<Test> getAllResults() {
        if (this.mTestPackages == null || this.mTestPackages.size() == 0) {
            return null;
        }
        ArrayList<Test> results = new ArrayList<Test>();
        for (TestPackage p : this.mTestPackages) {
            results.addAll(p.getTests());
        }
        return results;
    }

    public Collection<Test> getTestList(int resCode) {
        if (resCode < -1 || resCode > 5) {
            return null;
        }
        ArrayList<Test> tests = new ArrayList<Test>();
        for (Test test : this.getAllResults()) {
            if (resCode != test.getResult().getResultCode()) continue;
            tests.add(test);
        }
        return tests;
    }

    public Date getStartTime() {
        return this.mSessionStartTime;
    }

    public Date getEndTime() {
        return this.mSessionEndTime;
    }

    public Collection<TestPackage> getTestPackages() {
        return this.mTestPackages;
    }

    public String getResultPath() {
        return this.mResultPath;
    }

    public String getResultDir() {
        return this.mResultDir;
    }

    public void setStartTime(long time) {
        this.mSessionStartTime.setTime(time);
        String startTimeStr = HostUtils.getFormattedTimeString(time, "_", ".", ".");
        this.mResultDir = HostConfig.getInstance().getResultRepository().getRoot() + File.separator + startTimeStr;
        this.mResultPath = this.mResultDir + File.separator + CTS_RESULT_FILE_NAME;
        new File(this.mResultDir).mkdirs();
    }

    public void setEndTime(long time) {
        this.mSessionEndTime.setTime(time);
    }

    public void sessionComplete() {
        try {
            TestSessionLog.writeToFile(new File(this.mResultPath), this.createResultDoc());
            HostUtils.zipUpDirectory(this.mResultDir, this.mResultDir + ".zip", new HostUtils.ZipFilenameTransformer(){

                public String transform(String filename) {
                    if (filename.startsWith(TestSessionLog.this.mResultDir)) {
                        return filename.substring(TestSessionLog.this.mResultDir.length() + 1);
                    }
                    return filename;
                }
            });
        }
        catch (Exception e) {
            Log.e("Got exception when trying to write to result file", e);
        }
        HostConfig.getInstance().extractResultResources(this.mResultDir);
    }

    protected Document createResultDoc() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            ProcessingInstruction pr = doc.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\"  href=\"cts_result.xsl\"");
            doc.appendChild(pr);
            Element root = doc.createElement(TAG_TEST_RESULT);
            doc.appendChild(root);
            this.setAttribute(doc, (Node)root, ATTRIBUTE_VERSION, CTS_RESULT_FILE_VERSION);
            this.setAttribute(doc, (Node)root, ATTRIBUTE_STARTTIME, HostUtils.dateToString(this.mSessionStartTime));
            this.setAttribute(doc, (Node)root, ATTRIBUTE_ENDTIME, HostUtils.dateToString(this.mSessionEndTime));
            this.setAttribute(doc, (Node)root, ATTRIBUTE_TESTPLAN, this.mTestPlanName);
            for (int i = 0; i < this.mDeviceParameterBase.size(); ++i) {
                TestDevice.DeviceParameterCollector bldInfo = this.mDeviceParameterBase.get(i);
                Element deviceSettingNode = doc.createElement(TAG_DEVICEINFO);
                Element screenNode = doc.createElement(TAG_SCREEN);
                this.setAttribute(doc, (Node)screenNode, ATTRIBUTE_RESOLUTION, bldInfo.getScreenResolution());
                this.setAttribute(doc, (Node)screenNode, "screen_size", bldInfo.getScreenSize());
                this.setAttribute(doc, (Node)screenNode, "screen_density", bldInfo.getScreenDensity());
                this.setAttribute(doc, (Node)screenNode, "screen_density_bucket", bldInfo.getScreenDensityBucket());
                deviceSettingNode.appendChild(screenNode);
                Element simCardNode = doc.createElement(TAG_PHONE_SUB_INFO);
                this.setAttribute(doc, (Node)simCardNode, ATTRIBUTE_SUBSCRIBER_ID, bldInfo.getPhoneNumber());
                deviceSettingNode.appendChild(simCardNode);
                root.appendChild(deviceSettingNode);
                Element devInfoNode = doc.createElement(TAG_BUILD_INFO);
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_DEVICE_ID, bldInfo.getSerialNumber());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_BUILD_ID, bldInfo.getBuildId());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_BUILD_NAME, bldInfo.getProductName());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_BUILD_VERSION, bldInfo.getBuildVersion());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_ANDROID_PLATFORM_VERSION, bldInfo.getAndroidPlatformVersion());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_LOCALES, bldInfo.getLocales());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_XDPI, bldInfo.getXdpi());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_YDPI, bldInfo.getYdpi());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_TOUCH, bldInfo.getTouchInfo());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_NAVIGATION, bldInfo.getNavigation());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_KEYPAD, bldInfo.getKeypad());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_NETWORK, bldInfo.getNetwork());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_IMEI, bldInfo.getIMEI());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_IMSI, bldInfo.getIMSI());
                this.setAttribute(doc, (Node)devInfoNode, ATTRIBUTE_OPEN_GL_ES_VERSION, bldInfo.getOpenGlEsVersion());
                this.setAttribute(doc, (Node)devInfoNode, "build_fingerprint", bldInfo.getBuildFingerPrint());
                this.setAttribute(doc, (Node)devInfoNode, "build_type", bldInfo.getBuildType());
                this.setAttribute(doc, (Node)devInfoNode, "build_model", bldInfo.getBuildModel());
                this.setAttribute(doc, (Node)devInfoNode, "build_manufacturer", bldInfo.getBuildManufacturer());
                this.setAttribute(doc, (Node)devInfoNode, "build_brand", bldInfo.getBuildBrand());
                this.setAttribute(doc, (Node)devInfoNode, "build_board", bldInfo.getBuildBoard());
                this.setAttribute(doc, (Node)devInfoNode, "build_device", bldInfo.getBuildDevice());
                this.setAttribute(doc, (Node)devInfoNode, "build_abi", bldInfo.getBuildAbi());
                this.setAttribute(doc, (Node)devInfoNode, "build_abi2", bldInfo.getBuildAbi2());
                deviceSettingNode.appendChild(devInfoNode);
                this.addFeatureInfo(doc, deviceSettingNode, bldInfo);
                this.addProcessInfo(doc, deviceSettingNode, bldInfo);
            }
            Element hostInfo = doc.createElement(TAG_HOSTINFO);
            root.appendChild(hostInfo);
            String hostName = "";
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ignored) {
                // empty catch block
            }
            this.setAttribute(doc, (Node)hostInfo, ATTRIBUTE_NAME, hostName);
            Element osInfo = doc.createElement(TAG_OSINFO);
            hostInfo.appendChild(osInfo);
            this.setAttribute(doc, (Node)osInfo, ATTRIBUTE_NAME, System.getProperty("os.name"));
            this.setAttribute(doc, (Node)osInfo, ATTRIBUTE_VERSION, System.getProperty("os.version"));
            this.setAttribute(doc, (Node)osInfo, ATTRIBUTE_ARCH, System.getProperty("os.arch"));
            Element javaInfo = doc.createElement(TAG_JAVA);
            hostInfo.appendChild(javaInfo);
            this.setAttribute(doc, (Node)javaInfo, ATTRIBUTE_NAME, System.getProperty("java.vendor"));
            this.setAttribute(doc, (Node)javaInfo, ATTRIBUTE_VERSION, System.getProperty("java.version"));
            Element ctsInfo = doc.createElement(TAG_CTS);
            hostInfo.appendChild(ctsInfo);
            this.setAttribute(doc, (Node)ctsInfo, ATTRIBUTE_VERSION, Version.asString());
            for (HostConfig.Ints i : HostConfig.Ints.values()) {
                Element intValue = doc.createElement(TAG_INTVALUE);
                ctsInfo.appendChild(intValue);
                this.setAttribute(doc, (Node)intValue, ATTRIBUTE_NAME, i.name());
                this.setAttribute(doc, (Node)intValue, ATTRIBUTE_VALUE, i.value());
            }
            int passNum = this.getTestList(1).size();
            int failNum = this.getTestList(2).size();
            int omittedNum = this.getTestList(5).size();
            int notExecutedNum = this.getTestList(0).size();
            int timeOutNum = this.getTestList(4).size();
            Element summaryNode = doc.createElement(TAG_SUMMARY);
            root.appendChild(summaryNode);
            this.setAttribute(doc, (Node)summaryNode, ATTRIBUTE_PASS, passNum);
            this.setAttribute(doc, (Node)summaryNode, ATTRIBUTE_FAILED, failNum);
            this.setAttribute(doc, (Node)summaryNode, ATTRIBUTE_OMITTED, omittedNum);
            this.setAttribute(doc, (Node)summaryNode, ATTRIBUTE_NOT_EXECUTED, notExecutedNum);
            this.setAttribute(doc, (Node)summaryNode, ATTRIBUTE_TIMEOUT, timeOutNum);
            for (TestPackage testPackage : this.mTestPackages) {
                Element testPackageNode = doc.createElement(TAG_TESTPACKAGE);
                this.setAttribute(doc, (Node)testPackageNode, ATTRIBUTE_NAME, testPackage.getAppBinaryName());
                this.setAttribute(doc, (Node)testPackageNode, "appPackageName", testPackage.getAppPackageName());
                this.setAttribute(doc, (Node)testPackageNode, ATTRIBUTE_DIGEST, testPackage.getMessageDigest());
                if (testPackage instanceof SignatureCheckPackage) {
                    this.setAttribute(doc, (Node)testPackageNode, "signatureCheck", "true");
                }
                for (TestSuite testSuite : testPackage.getTestSuites()) {
                    this.outputTestSuite(doc, testPackage, testPackageNode, testSuite);
                }
                root.appendChild(testPackageNode);
            }
            return doc;
        }
        catch (Exception e) {
            Log.e("create result doc failed", e);
            return null;
        }
    }

    private void addFeatureInfo(Document document, Node parentNode, TestDevice.DeviceParameterCollector deviceInfo) {
        String[] featurePairs;
        Element featureInfo = document.createElement(TAG_FEATURE_INFO);
        parentNode.appendChild(featureInfo);
        String features = deviceInfo.getFeatures();
        if (features == null) {
            features = "";
        }
        for (String featurePair : featurePairs = features.split(";")) {
            String[] nameTypeAvailability = featurePair.split(":");
            if (nameTypeAvailability.length < 3) continue;
            Element feature = document.createElement(TAG_FEATURE);
            featureInfo.appendChild(feature);
            this.setAttribute(document, (Node)feature, ATTRIBUTE_NAME, nameTypeAvailability[0]);
            this.setAttribute(document, (Node)feature, ATTRIBUTE_TYPE, nameTypeAvailability[1]);
            this.setAttribute(document, (Node)feature, ATTRIBUTE_AVAILABLE, nameTypeAvailability[2]);
        }
    }

    private void addProcessInfo(Document document, Node parentNode, TestDevice.DeviceParameterCollector deviceInfo) {
        String[] processNames;
        Element processInfo = document.createElement(TAG_PROCESS_INFO);
        parentNode.appendChild(processInfo);
        String rootProcesses = deviceInfo.getProcesses();
        if (rootProcesses == null) {
            rootProcesses = "";
        }
        for (String processName : processNames = rootProcesses.split(";")) {
            if ((processName = processName.trim()).length() <= 0) continue;
            Element process = document.createElement(TAG_PROCESS);
            processInfo.appendChild(process);
            this.setAttribute(document, (Node)process, ATTRIBUTE_NAME, processName);
            this.setAttribute(document, (Node)process, ATTRIBUTE_UID, "0");
        }
    }

    private void outputTestSuite(Document doc, TestPackage testPackage, Node parentNode, TestSuite testSuite) {
        Collection<TestSuite> subSuites = testSuite.getSubSuites();
        Collection<TestCase> testCases = testSuite.getTestCases();
        Element testSuiteNode = doc.createElement(TAG_TESTSUITE);
        this.setAttribute(doc, (Node)testSuiteNode, ATTRIBUTE_NAME, testSuite.getName());
        for (TestCase testCase : testCases) {
            Element testCaseNode = doc.createElement(TAG_TESTCASE);
            testSuiteNode.appendChild(testCaseNode);
            this.setAttribute(doc, (Node)testCaseNode, ATTRIBUTE_NAME, testCase.getName());
            this.setAttribute(doc, (Node)testCaseNode, "priority", testCase.getPriority());
            Collection<Test> tests = testCase.getTests();
            for (Test test : tests) {
                Element testNode = doc.createElement("Test");
                testCaseNode.appendChild(testNode);
                if (test.isKnownFailure()) {
                    this.setAttribute(doc, (Node)testNode, ATTRIBUTE_KNOWN_FAILURE, test.getKnownFailure());
                }
                CtsTestResult result = test.getResult();
                this.setAttribute(doc, (Node)testNode, ATTRIBUTE_NAME, test.getName());
                this.setAttribute(doc, (Node)testNode, ATTRIBUTE_RESULT, result.getResultString());
                this.setAttribute(doc, (Node)testNode, ATTRIBUTE_STARTTIME, new Date(test.getStartTime()).toString());
                this.setAttribute(doc, (Node)testNode, ATTRIBUTE_ENDTIME, new Date(test.getEndTime()).toString());
                String failedMessage = result.getFailedMessage();
                if (failedMessage == null) continue;
                failedMessage = HostUtils.replaceControlChars(failedMessage);
                Element failedMessageNode = doc.createElement(TAG_FAILED_SCENE);
                testNode.appendChild(failedMessageNode);
                this.setAttribute(doc, (Node)failedMessageNode, TAG_FAILED_MESSAGE, failedMessage);
                String stackTrace = TestSessionLog.sanitizeStackTrace(result.getStackTrace());
                if (stackTrace == null) continue;
                Element stackTraceNode = doc.createElement(TAG_STACK_TRACE);
                failedMessageNode.appendChild(stackTraceNode);
                Text stackTraceTextNode = doc.createTextNode(stackTrace);
                stackTraceNode.appendChild(stackTraceTextNode);
            }
        }
        for (TestSuite subSuite : subSuites) {
            this.outputTestSuite(doc, testPackage, testSuiteNode, subSuite);
            parentNode.appendChild(testSuiteNode);
        }
        parentNode.appendChild(testSuiteNode);
    }

    private static String sanitizeStackTrace(String trace) {
        if (trace != null) {
            return trace.replaceAll("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD]", "");
        }
        return null;
    }

    public static final String[] getFailedLineNumber(String failedResult) {
        Matcher m = mTestFailedPattern.matcher(failedResult);
        if (m.matches()) {
            return new String[]{m.group(1), m.group(2)};
        }
        return null;
    }

    public void setDeviceInfo(TestDevice.DeviceParameterCollector dInfo) {
        for (TestDevice.DeviceParameterCollector collector : this.mDeviceParameterBase) {
            if (!collector.getSerialNumber().equals(dInfo.getSerialNumber())) continue;
            this.mDeviceParameterBase.remove(collector);
            break;
        }
        this.mDeviceParameterBase.add(dInfo);
    }
}

