class Convertisseur {
  
  Convertisseur() {
  }
  
  byte[] convertir (PImage image){
    return optimiseVdt(pix_char(image));
  }
  
  

  public int[][] pixAff(PImage image){
    int[][] retour = new int[80][72];
    image.resize(80, 72);
    image.loadPixels();
    for (int y=0; y<24; y++) {
      for (int x=0; x<40; x++) { 
        int[] coulTextFond = calcCoulTextFond(x, y, image);
        int xPix = x * 2;
        int yPix = y * 3;
        for (int b = yPix; b<=yPix+2; b++) {
          for (int a = xPix; a <=xPix+1; a++) {
            if(etat(a, b, coulTextFond, image) == 1){
              retour[a][b] = floor(coulTextFond[0]/32)*32;
            }
            if(etat(a, b, coulTextFond, image) == 0){
              retour[a][b] = floor(coulTextFond[1]/32)*32;
            }
          }
        }
      }
    }
    return retour;
  }
  
  /* Fonction pix_char
   Cette fonction permet de convertir une image numerique actuelle au format jpg, png, gif ... en une chaine de caracteres
   au format videoTex.
   Le tableau lumCoul permet de classer les 8 couleurs du minitel en fonction de leur luminosite !
   Cette fonction pix_char fait appel a deux autres fonctions : 
   calcCoulTextFond qui calcule pour chaque caractere la couleur du texte et celle du fond.
   calcChar qui calcule le caractere semi graphique a appliquer
   
   Pour chaque caractere a afficher par le minitel, on envoie la suite d'octet suivante:
   0x1B [0-8]+0x40       Pour la couleur du texte
   0x1B [0-8]+0x50       Pour la couleur du fond
   le caractere semi graphique
   
   coulTextFond[0] est la couleur du texte calculée, comprise entre 0 et 255.
   coulTextFond[1] est la couleur du fond calculée, comprise entre 0 et 255. 
   On les divise par 32 pour que les couleurs soient comprise entre 0 et 8.
   
   */
  private byte[] pix_char(PImage image) {
    int index = 0;
    byte [] chaineVdt = new byte [8000];
    byte [] lumCoul = {0, 4, 1, 5, 2, 6, 3, 7};
    image.resize(80, 72);
    image.loadPixels();
    for (int y=0; y<24; y++) {
      for (int x=0; x<40; x++) {   
        int[] coulTextFond = calcCoulTextFond(x, y, image);   
        chaineVdt[index] = 27;
        index++;
        chaineVdt[index] = byte(lumCoul[floor(coulTextFond[0]/32)]+0x40);
        index++;
        chaineVdt[index] = 27;
        index++;
        chaineVdt[index] = byte(lumCoul[floor(coulTextFond[1]/32)]+0x50);
        index++;
        chaineVdt[index] = calcChar(x, y, coulTextFond, image);
        index++;
      }
    }
    byte [] chaineVdtFinale = new byte [index];
    for (int i = 0; i<index; i++) {
      chaineVdtFinale[i] = chaineVdt[i];
    }
    return chaineVdtFinale;
  }


  /* 
   Calcule la couleur du texte et la couleur du fond a partir de la luminosite dans l'image
   La couleur du texte couleur[0] est la plus faible luminosite
   La couleur du fond couleur[1] est la plus grande luminosite
   La luminosite (niveaux de gris) est comprise entre 0 et 255.
   */

  private int[] calcCoulTextFond(int x, int y, PImage image) {
    int[] couleur = new int[2];
    int xPix = x * 2;
    int yPix = y * 3;
    int lum = (int)brightness(image.pixels[xPix + yPix*image.width]);
    couleur[0] = lum;
    couleur[1] = lum;
    for (int b = yPix; b<=yPix+2; b++) {
      for (int a = xPix; a <=xPix+1; a++) {
        lum = (int)brightness(image.pixels[a + b*image.width]);
        if (lum<couleur[0]) {
          couleur[0]=lum;
        }
        if (lum>couleur[1]) {
          couleur[1]=lum;
        }
      }
    }
    return couleur;
  }

  /*
Calcule le caractere correspondant dans le jeu semi graphique
   Utilise la fonction etat qui compare la couleur de chaque pixel
   par rapport à la couleur du fond et la couleur du texte.
   Cette fonction envoit 1 si la couleur du pixel est plus proche de la couleur du texte
   Cette fonction envoit 0 si la couleur du pixel est plus proche de la couleur du fond
   */
  private byte calcChar(int x, int y, int[] coulTextFond, PImage image) {
    int xPix = x * 2;
    int yPix = y * 3;
    byte carac=0; // caractère pixel
    carac+=(Math.pow(2, 0))*etat(xPix, yPix, coulTextFond, image);
    carac+=(Math.pow(2, 1))*etat(xPix+1, yPix, coulTextFond, image);
    carac+=(Math.pow(2, 2))*etat(xPix+0, yPix+1, coulTextFond, image);
    carac+=(Math.pow(2, 3))*etat(xPix+1, yPix+1, coulTextFond, image);
    carac+=(Math.pow(2, 4))*etat(xPix+0, yPix+2, coulTextFond, image);
    carac+=(Math.pow(2, 5))*1;
    carac+=(Math.pow(2, 6))*etat(xPix+1, yPix+2, coulTextFond, image);
    return carac;
  }

  private int etat(int x, int y, int[] coulTextFond, PImage image) {
    color c = image.pixels[x + y*image.width];
    int couleur = (int)brightness(c);  
    if (abs(coulTextFond[0]-couleur) > abs(coulTextFond[1]-couleur)) {
      return(0);
    } else {
      return(1);
    }
  }
  
    byte[] optimiseVdt(byte[] chaine){
    int n = chaine.length;
    byte [] chaineTemp = new byte [n];
    int octetFond = 0;
    int octetTexte = 0;
    int indexTemp = 0;
    for (int i=1 ; i<n ; i++){
      if (chaine[i-1] == 27){
        if (chaine[i]>=0x50){
          if (chaine[i] != octetFond){
            chaineTemp[indexTemp] = 27;
            chaineTemp[indexTemp+1]=chaine[i];
            indexTemp +=2;
          }
          octetFond = chaine[i];
        }
        else{
         if (chaine[i] != octetTexte){
            chaineTemp[indexTemp] = 27;
            chaineTemp[indexTemp+1]=chaine[i];
            indexTemp +=2;
          }
          octetTexte = chaine[i];
        }
      }
      else if (chaine[i] != 27){
        chaineTemp[indexTemp]=chaine[i];
        indexTemp++;
      }
    }
    byte[] chaineRetour = new byte[indexTemp];
    for (int i = 0; i<indexTemp;i++){
      chaineRetour[i] = chaineTemp[i];
    }
    return chaineRetour;
  }
}
