import processing.video.*;
Movie myMovie;
int iFrame = 0;
int nFrame = 1677;
PImage[] img;
Convertisseur convertisseur;
byte [] chaineVdtConvertie;
int[][] pixMin;
byte a = 12;
ArrayList<Byte> octets = new ArrayList<Byte>();
boolean stopDraw = false;

void setup() {
  size(800, 600);
  convertisseur = new Convertisseur();
  background(0);
  myMovie = new Movie(this, "psycho.avi");
  myMovie.loop();
  img = new PImage[nFrame+1];
  frameRate(24);
  myMovie.frameRate(24);
  octets.add(a); // efface écran
  a=14;
  octets.add(a); // semi graphique
}

void draw() {
  if (!stopDraw) {
    image(myMovie, 0, 0);
    text(iFrame, 20, 20);
    img[iFrame] = myMovie;
    // curseur en haut à gauche
    a = 31;
    octets.add(a);
    a = 64;
    octets.add(a);
    a = 64;
    octets.add(a);

    chaineVdtConvertie = convertisseur.convertir(img[iFrame]);

    pixMin = convertisseur.pixAff(img[iFrame]);
    int scale = 5;
    noStroke();
    for (int y=0; y<72; y++) {
      for (int x=0; x<80; x++) {
        fill(pixMin[x][y]);
        rect(width/6+scale*x, 40+scale*y, scale, scale);
      }
    }

    for (int i=0; i<chaineVdtConvertie.length; i++) {
      octets.add(chaineVdtConvertie[i]);
    }
    if (iFrame==nFrame) {
      byte [] aSauver = new byte [octets.size()];
      for (int i=0; i<octets.size(); i++) {
        aSauver[i] = octets.get(i);
      }
      saveBytes(dataPath("psycho.vdt"), aSauver);
      exit();
    }
    iFrame++;
  }
}

// Called every time a new frame is available to read
void movieEvent(Movie m) {
  m.read();
}

void mousePressed() {
  stopDraw = !stopDraw;
  if(stopDraw)  myMovie.pause();
  else myMovie.play();
}
